/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ui.customizer.CustomizerProvider3;
import org.netbeans.modules.java.api.common.project.ui.customizer.ProjectSharability;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.api.J2SECustomPropertySaver;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public class CustomizerProviderImpl
implements CustomizerProvider3,
ProjectSharability {
    private final J2SEProject project;
    private final UpdateHelper updateHelper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFileHelper;
    private RequestProcessor rp = new RequestProcessor("customizer init", 1);
    private static final String CUSTOMIZER_FOLDER_PATH = "Projects/org-netbeans-modules-java-j2seproject/Customizer";
    private static Map<Project, Dialog> project2Dialog = new HashMap<Project, Dialog>();
    private boolean isOpening;

    public CustomizerProviderImpl(J2SEProject project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper, GeneratedFilesHelper genFileHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
        this.genFileHelper = genFileHelper;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String preselectedCategory) {
        this.showCustomizer(preselectedCategory, null);
    }

    public void showCustomizer(final String preselectedCategory, final String preselectedSubCategory) {
        Dialog dialog = project2Dialog.get(this.project);
        if (dialog != null) {
            dialog.setVisible(true);
            return;
        }
        WaitCursor.show();
        if (this.isOpening) {
            return;
        }
        this.rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CustomizerProviderImpl.this.isOpening = true;
                try {
                    J2SEProjectProperties uiProperties = CustomizerProviderImpl.this.createJ2SEProjectProperties();
                    final Lookup context = Lookups.fixed((Object[])new Object[]{CustomizerProviderImpl.this.project, uiProperties, new SubCategoryProvider(preselectedCategory, preselectedSubCategory)});
                    final OptionListener listener = new OptionListener(CustomizerProviderImpl.this.project, uiProperties);
                    final StoreListener storeListener = new StoreListener(CustomizerProviderImpl.this.project, uiProperties);
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                Dialog dialog2 = ProjectCustomizer.createCustomizerDialog((String)CustomizerProviderImpl.CUSTOMIZER_FOLDER_PATH, (Lookup)context, (String)preselectedCategory, (ActionListener)listener, (ActionListener)storeListener, null);
                                dialog2.addWindowListener(listener);
                                dialog2.setTitle(MessageFormat.format(NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)CustomizerProviderImpl.this.project).getDisplayName()));
                                project2Dialog.put(CustomizerProviderImpl.this.project, dialog2);
                                dialog2.setVisible(true);
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                finally {
                    CustomizerProviderImpl.this.isOpening = false;
                    WaitCursor.hide();
                }
            }
        });
    }

    private J2SEProjectProperties createJ2SEProjectProperties() {
        return new J2SEProjectProperties(this.project, this.updateHelper, this.evaluator, this.refHelper, this.genFileHelper);
    }

    public boolean isSharable() {
        return this.project.getAntProjectHelper().isSharableProject();
    }

    public void makeSharable() {
        this.createJ2SEProjectProperties().makeSharable();
    }

    public void cancelCustomizer() {
        Dialog dialog = project2Dialog.get(this.project);
        if (dialog != null) {
            dialog.setVisible(false);
            dialog.dispose();
            project2Dialog.remove(this.project);
        }
    }

    public static class WaitCursor
    implements Runnable {
        private boolean show;

        private WaitCursor(boolean show) {
            this.show = show;
        }

        public static void show() {
            WaitCursor.invoke(new WaitCursor(true));
        }

        public static void hide() {
            WaitCursor.invoke(new WaitCursor(false));
        }

        private static void invoke(WaitCursor wc) {
            if (SwingUtilities.isEventDispatchThread()) {
                wc.run();
            } else {
                SwingUtilities.invokeLater(wc);
            }
        }

        @Override
        public void run() {
            try {
                JFrame f = (JFrame)WindowManager.getDefault().getMainWindow();
                Component c = f.getGlassPane();
                c.setVisible(this.show);
                c.setCursor(this.show ? Cursor.getPredefinedCursor(3) : null);
            }
            catch (NullPointerException npe) {
                Exceptions.printStackTrace((Throwable)npe);
            }
        }
    }

    static final class SubCategoryProvider {
        private String subcategory;
        private String category;

        SubCategoryProvider(String category, String subcategory) {
            this.category = category;
            this.subcategory = subcategory;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSubcategory() {
            return this.subcategory;
        }
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;
        private J2SEProjectProperties uiProperties;

        OptionListener(Project project, J2SEProjectProperties uiProperties) {
            this.project = project;
            this.uiProperties = uiProperties;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ActionListener actionListener : this.uiProperties.getOptionListeners()) {
                actionListener.actionPerformed(e);
            }
            Dialog dialog = project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            project2Dialog.remove(this.project);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Dialog dialog = project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }

    private class StoreListener
    implements ActionListener {
        private Project project;
        private J2SEProjectProperties uiProperties;

        StoreListener(Project project, J2SEProjectProperties uiProperties) {
            this.project = project;
            this.uiProperties = uiProperties;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.uiProperties.save();
            for (J2SECustomPropertySaver saver : this.project.getLookup().lookupAll(J2SECustomPropertySaver.class)) {
                saver.save(this.project);
            }
        }
    }
}

